<?php
/**
  * ルビ振り処理プログラム
  *
  * @package     NetCommons
  * @author      AllCreator Co., Ltd.
  * @copyright   2014 AllCreator Co., Ltd.
  * @project     NetCommons Commercial Service Project, provided by AllCreator Co., Ltd.
  * @license     http://service.allcreator.net/ac_docs/commercial_software_license.txt Commercial License
  * @access      public
  */
  
function rubirubi($html, $cmd){

	$params = array();
	$params['cmd'] = $cmd;
	$params['others'] = array();
	$params['others']['rubi_degree'] = $rubi_degree = getSessionRubiParameter('rubi_degree');	//$rubi_degreeにも代入
	$params['others']['isAndroidSmartPhone'] = $androidSP =  isAndroidSmartPhone();	//$androidSPにも代入

	$rubi = getSessionRubiParameter('rubi_switch');

	if($rubi==null || $rubi=='0'){
       	//セッションのルビが無効。
       	if(!(isset($_POST['rubifuri_flag']) && $_POST['rubifuri_flag']==='1')){
        	return $html; //POSTのルビふりフラグもないので、なにもせず、返す。
       	} else {
        	;   //ルビが無効だが、POSTのルビふりフラグがonできたので、ルビをふる！
       	}
	}

   	if((isset($_POST['rubifuri_flag']) && $_POST['rubifuri_flag']==='0')){
		//sessionはどうであれ、ユーザ自身により、ルビを振るな！と明示的に指定されたケース。
		//基本、savezipでPOSTされてきたケース
		return $html; //POSTのルビふりフラグもないので、なにもせず、返す。
	}

	if(isset($_SESSION['_layoutmode']) && $_SESSION['_layoutmode']=='on')
		return $html;	//_layoutmodeがon。この場合は画面が崩れるのでルビは降らない。（ルビの有効・無効に関係なし）

	$htmldoc_flag = ($cmd==="savezip") ? false : isHTMLDocument($html);
	if(!$htmldoc_flag){
		$params['decoded_html'] = $decoded_html = rawurldecode( (getContentEncoding()==='gzip') ? doGzdecode($html) : $html );
		if(strpos($decoded_html, "error_message:")===0){
			//ajax処理のエラーを通知するケースなので、そのままreturnする。
			return $html;
      	}
	} else {
		//cmd != gzipなので、圧縮されていない平文である。
		//
		$params['decoded_html'] = $html;
	}

	//認証用パラメータ
	$authparams = getAuthParams();
	$params['others']['member_code'] = $authparams['member_code'];
	$params['others']['member_hashedpwd'] = $authparams['member_hashedpwd'];

    //アクセス回数計測用パラメータ
	$params['others']['server_addr'] = $_SERVER['SERVER_ADDR'];
	$params['others']['base_url'] = BASE_URL;

	//学習支援モジュール用ロジック(実装中)
    //特定文字列を伏せ、読みだけを残すテストモード（書き取りテスト)
	//
	//TODO 通常のアクセシビリティとは違う、学習支援Ｍ用なので、サービスコードを変えること。
	//
	$params['others']['exlearn_test_mode'] = 2; //1; //1;//0;1;2;3;4;

	//クライアントキャッシュ関連処理 
	//
	$html_sha1 = sha1($params['decoded_html']);
	$html_cachedir = dirname(__FILE__).'/rubicache';
	$webapi_returned_htmls = searchRubiCacheFile($html_cachedir, $html_sha1);
    if($webapi_returned_htmls === false){
		//クライアントキャッシュにヒットしない...なので

		//まずはWebAPIによるルビ変換処理を実行.

		if(($webapi_server_place = getWebApiServerPlace())==''){
			//問い合わせすべきWebAPIサーバのuriが取得できないケースなので、そのままreturnする。
			return $html;
		}

		//WebAPIを呼ぶ
		try {
			$client = new SoapClient(null, array(
				'location' => $webapi_server_place,
				'uri' => $webapi_server_place,
				'trace' => 1,
				'exceptions' => 1	//0 -> 1
			));

			$wk2_html = $client->__soapCall("doRubi",array(serialize($params)));
			//WebAPIから戻る
		} catch (Exception $ex) {
			//Soap通信失敗につき、そのままhtmlを返す. $ex->getMessage()で例外理由が取得できる.
			return $html;
		}

		$rubi_cache_allow_flag = 0;
		$rubi_caching_day = 0;
		getCacheAllowFlagAndDays($rubi_cache_allow_flag,$rubi_caching_day);

		if($rubi_cache_allow_flag == 1){
			//キャッシュが許可されている
			//
			if(strpos($wk2_html,'setToken')===false){
				//token値が含まれていない時は、WebAPIからの応答をクライアントにキャッシュする。
				if(file_put_contents($html_cachedir.'/'.$html_sha1, base64_encode($wk2_html))===false){
					//キャッシュ保存でエラーがあっても、続行する。
       			}
			}
		}

		if($rubi_caching_day > 0){
			//保存日数が1日以上なので、保存期間をすぎた古いWebAPI結果のキャッシュファイルを削除
			//
			deleteOldRubiCacheFileEx($html_cachedir,$rubi_caching_day);
		}
	}
	else {
		//クライアントキャッシュにヒットした!

		//WebAPI応答をキャッシュファイルから持ってくる
		$wk2_html = base64_decode(file_get_contents($html_cachedir.'/'.$html_sha1));
	}

	$rubi_teisei_jikko_cnt = 0;		//doTeiseiRub()を複数回実行しないための関数実行回数カウント

	$savezip_wrapper_begin = '<div id="_ncac_div_wrapper_for_rubi">';
	$savezip_wrapper_end = '</div>';

    $xml_flag = isXMLDocument($html);   //XMLドキュメントかどうか判断する。
    if(!$htmldoc_flag){
	  if(!$xml_flag){
		  //XML文書じゃない。
		  //つまり、通常のajaxの後処理
	      //ajax用の部分htmlなので、<!DOCTYP～<body>と</body></html>をストリップし、その中身を抜き出す。
		  //
	      if($cmd==='savezip'){

			//この時点で、ルビ振りの過程で、"?action=...&upload_id="が"?action=...&amp;upload_id="と
			//&が&amp;に変換されている。
			//このまま、下にながすと、webapp/modules/common/download/zip/Zip.class.phpの中で、
			//"?action=...&upload_id="を見つけにいっている処理にマッチせず、画像パスの変換および、
			//画像のＰＣへの送信がされなくなる現象を発見。ゆえに、まずは、この変換をもとに戻す。
			//	
			$wk2_html = preg_replace('/action=([^&].+?)&amp;upload_id=/u', "action=\\1&upload_id=", $wk2_html);
	
	
			//savezipの時、bodyのすぐあとに、textnodeがくると、正しくルビをふってくれない現象あり。
		    //それを避けるため、savezipの時は、decoded_htmlを専用divでラップする。
			//
	      	$pos1 = strpos($wk2_html, "<body>".$savezip_wrapper_begin );
	      	$pos2 = strrpos($wk2_html, $savezip_wrapper_end."</body>" );
	        $body_tag_and_alpha_len = strlen("<body>".$savezip_wrapper_begin );
	      } else {
	      	$pos1 = strpos($wk2_html, "<body>");
	      	$pos2 = strrpos($wk2_html, "</body>");
	        $body_tag_and_alpha_len = strlen("<body>");
		  }
		  if($pos1 !== false && $pos2 !== false){	//2014.03.08 mod by TH ... null -> false に変更
	        $wk2_html = substr($wk2_html, ($pos1 + $body_tag_and_alpha_len),  (strlen($wk2_html) - ( ($pos1 + $body_tag_and_alpha_len) +  strlen(substr($wk2_html,$pos2)))));

		    //gzipの場合、ルビ訂正が実行されていなかったら１回訂正をかけてから、gzencode()する。
	        if(getContentEncoding()==='gzip'){
				 if($rubi_teisei_jikko_cnt === 0){
				 	$wk2_html = doTeiseiRubi($wk2_html);
				 	$rubi_teisei_jikko_cnt++;
				 }
				 $wk2_html = gzencode($wk2_html);
			}
	
	      } else {
	        //うまく<body>内部がきりだせなかった。。仕方ないので、入力の$htmlをそのまま返す。
	        $wk2_html = $html;
	      }
	  } else {
		  //XML文書
		  //つまり、ajaxでも中身がXMLだったときの後処理を行う。

	      //XMLでもajaxなのでgzipされていた可能性はある。

		  //gzipの場合、ルビ訂正が実行されていなかったら１回訂正をかけてから、gzencode()する。
	      if(getContentEncoding()==='gzip'){
		  	if($rubi_teisei_jikko_cnt === 0){
				$wk2_html = doTeiseiRubi($wk2_html);
			 	$rubi_teisei_jikko_cnt++;
			 }
			 $wk2_html = gzencode($wk2_html);
		  }
	  }

   }


	//ルビ訂正が１回も実行されていなかったら訂正をかける。
	if($rubi_teisei_jikko_cnt === 0){
			$wk3_html = doTeiseiRubi($wk2_html);
	} else {
		$wk3_html = $wk2_html;
	}

   return $wk3_html;	//mob by TH. $wk2_htmlから$wk3_htmlに変えた。
}

//CL_FNC
//スマートフォンのアンドロイドかどうかを調べる
//
//NCのmaple/nccore/MobileCheck.class.phpのisSmartPhone()に合わせて実装
//
function isAndroidSmartPhone() {
	$userAgent = strtolower(@$_SERVER['HTTP_USER_AGENT']);
    return (strpos($userAgent,"android 2") !== false && strpos($userAgent,"mobile") !== false) ? true : false;
}

//CL_FNC
// セッション情報を取り出す
//
function getSessionRubiParameter($name) {
	$ret_val = null;

    // 現在表示中ルームIDが設定されているか
    if(isset($_SESSION['_main_room_id']) ){
    	$target_room_id =  $_SESSION['_main_room_id'];
    }
    else {
    	$target_room_id =  0;
    }
    
    // 指定のパラメータがあるか
    if(isset($_SESSION[$name])) {
    	// 指定パラメータの現在ルームの情報があるか
        if(isset($_SESSION[$name][$target_room_id])) {
            $ret_val = $_SESSION[$name][$target_room_id];
    	}
    	// ない場合はデフォルト値を使う
    	else {
            $ret_val = $_SESSION[$name][0];
    	}
    }
    // 指定が無い時はデフォルトのままとする:TODO:
    else {
    }
	return $ret_val;
}

//CL_FNC
//XMLドキュメントかそうでないかを判断する
//
function isXMLDocument($xml) {
	return (strpos(trim($xml), "<?xml version=")===0) ?  true : false;
}

//CL_FNC
//HDMLdocumentかajaxの部分htmlかを判断する
//
function isHTMLDocument($html) {
  return (strpos(trim($html), "<!DOCTYPE html")===0) ?  true : false;
}

//CL_FNC
//gzdecode()がPHPに存在しないので、これを使う
//第二引数にacwork_pathを追加.
//
function doGzdecode($data) {
  $rubitmpdir = dirname(__FILE__).'/rubitmp';
  do {
    $tempName = $rubitmpdir.'/'.uniqid('actemp_');
  } while (file_exists($tempName));

  $buffer = "";
  if (file_put_contents($tempName, $data)) {
    $handle = gzopen($tempName, 'r');
    while (!gzeof($handle)) {
      $buffer .= gzgets($handle, 4096);
    }
    gzclose($handle);
    unlink($tempName);
    return $buffer;
  }
  return false;
}

//CL_FNC
//レスポンスヘッダーを調べ、Content-Encodingを返す。(gzipかどうかを判断するため)
//
function getContentEncoding(){
	$res_headers = headers_list();  //送信済かどうかは関与しないので、headers_sent()は不要。
    foreach($res_headers as $res_header){
		$keyval = explode(":",$res_header);
        if(count($keyval)===2 && trim($keyval[0])==='Content-Encoding'){
			return trim($keyval[1]);
        }
    }
    return null;
}

//CL_FNC
//ルビ訂正処理
//
function doTeiseiRubi(&$input_html){

	$output_html = $input_html;	//出力データを入力データで初期化

	$mysqli = false;
	if(($mysqli = connectDB())===false){
		return $output_html;	//(未編集の)出力データをそのまま返す
	}

	if(($rubiset_a = getRubiSetTbl($mysqli))===false){
		if($mysqli!==false) $mysqli->close();
		return $output_html;	//(未編集の)出力データをそのまま返す
	}


	$esc_base_url = str_replace('.','\.',str_replace('/','\/',BASE_URL));
	$referer = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : '';
	$str_type = 's';
	foreach($rubiset_a as $rubiset){

		//ページID
		if($rubiset['page_ids'] !== '-'){		//'-'(抑止)ではない.
			if( $rubiset['page_ids'] === '*' || (isset($_REQUEST['page_id']) && preg_match('/^('.$rubiset['page_ids'].')$/', $_REQUEST['page_id'])===1) ){	//全一致(*)またはpage_id一致
				//rubi訂正を試みる。
				//$output_html = str_replace($rubiset['search_str'], $rubiset['replace_str'], $output_html);

				if($rubiset['enable_flg']=='e'){
            		//正規表現
            		$ret = @preg_replace('/'.$rubiset['search_str'].'/u', $rubiset['replace_str'], $output_html);
					if($ret === null){
                		//置換失敗. 正規表現が悪い？
            		} else {
                		//置換成功
               		 	$output_html = $ret;
            		}
        		}
        		else if($rubiset['enable_flg']==$str_type){	
            		$output_html = str_replace($rubiset['search_str'], $rubiset['replace_str'], $output_html);
        		}
				continue;	//次のルビ訂正に進む
			}
		}


		//固定リンク
		// pageテーブルpermalinkデータ ex. 'group/aaa/bbb', 'xxx/日本'

		if($rubiset['permalinks'] !== '-'){		//'-'(抑止)ではない.
			if( $rubiset['permalinks'] === '*'){
				//rubi訂正を試みる。
				//$output_html = str_replace($rubiset['search_str'], $rubiset['replace_str'], $output_html);

				if($rubiset['enable_flg']=='e'){
            		//正規表現
            		$ret = @preg_replace('/'.$rubiset['search_str'].'/u', $rubiset['replace_str'], $output_html);
					if($ret === null){
                		//置換失敗. 正規表現が悪い？
            		} else {
                		//置換成功
               			 $output_html = $ret;
            		}
        		}
        		else if($rubiset['enable_flg']==$str_type){	
            		$output_html = str_replace($rubiset['search_str'], $rubiset['replace_str'], $output_html);
        		}
				continue;

			} else if(($permalinks=explode('|',$rubiset['permalinks'])) > 0){
				$replace_flg = false;
				foreach($permalinks as $permalink){
					$esc_permalink = str_replace('.','\.',str_replace('/','\/',trim($permalink)));
					$regex = '/^'.$esc_base_url.'\/'.$esc_permalink.'(\/(index.php|)(\?.+|)|)$/u';
    				if(preg_match($regex, $referer)===1){
						//rubi訂正を試みる。
						//$output_html = str_replace($rubiset['search_str'], $rubiset['replace_str'], $output_html);

						if($rubiset['enable_flg']=='e'){
		            		//正規表現
		            		$ret = @preg_replace('/'.$rubiset['search_str'].'/u', $rubiset['replace_str'], $output_html);
							if($ret === null){
		                		//置換失敗. 正規表現が悪い？
		            		} else {
		                		//置換成功
		               			 $output_html = $ret;
		            		}
		        		}
		        		else if($rubiset['enable_flg']==$str_type){	
		            		$output_html = str_replace($rubiset['search_str'], $rubiset['replace_str'], $output_html);
		        		}
						$replace_flg = true;
						break;
					}
				}
				if($replace_flg) continue;	//次のルビ訂正に進む
			}
		}

		//短縮URL
		// abbreviate_urlテーブルのshort_urlデータ ex. 'jo4caig3m','jogn5ewch'

		if($rubiset['short_urls'] !== '-'){		//'-'(抑止)ではない.
			if( $rubiset['short_urls'] === '*'){
				//rubi訂正を試みる。
				//$output_html = str_replace($rubiset['search_str'], $rubiset['replace_str'], $output_html);

				if($rubiset['enable_flg']=='e'){
            		//正規表現
            		$ret = @preg_replace('/'.$rubiset['search_str'].'/u', $rubiset['replace_str'], $output_html);
					if($ret === null){
                		//置換失敗. 正規表現が悪い？
            		} else {
                		//置換成功
               			 $output_html = $ret;
            		}
        		}
        		else if($rubiset['enable_flg']==$str_type){	
            		$output_html = str_replace($rubiset['search_str'], $rubiset['replace_str'], $output_html);
        		}
				continue;

			} else if(($short_urls=explode('|',$rubiset['short_urls'])) > 0){
				$replace_flg = false;
				foreach($short_urls as $short_url){
					$short_url = trim($short_url);
					$regex = '/^'.$esc_base_url.'\/'.$short_url.'(|\/|-.+)$/';
    				if(preg_match($regex, $referer)===1){
						//rubi訂正を試みる。
						//$output_html = str_replace($rubiset['search_str'], $rubiset['replace_str'], $output_html);

						if($rubiset['enable_flg']=='e'){
		            		//正規表現
		            		$ret = @preg_replace('/'.$rubiset['search_str'].'/u', $rubiset['replace_str'], $output_html);
							if($ret === null){
		                		//置換失敗. 正規表現が悪い？
		            		} else {
		                		//置換成功
		               			 $output_html = $ret;
		            		}
		        		}
		        		else if($rubiset['enable_flg']==$str_type){	
		            		$output_html = str_replace($rubiset['search_str'], $rubiset['replace_str'], $output_html);
		        		}
						$replace_flg = true;
						break;
					}
				}
				if($replace_flg) continue;	//次のルビ訂正に進む
			}
		}

	}
	return $output_html;
}
//CL_FNC
//DB接続処理
//
function connectDB(){

	$dsn = DATABASE_DSN;
	$dbname = substr( $dsn, strrpos($dsn, '/')+1);
	$dsn = substr($dsn, 0, strrpos($dsn, '/'));
	
	$dbhost = substr($dsn, strrpos($dsn, '@')+1);
	$dsn = substr($dsn, 0, strrpos($dsn, '@'));
	
	$dbpasswd = substr($dsn, strrpos($dsn, ':')+1);
	$dsn = substr($dsn, 0, strrpos($dsn, ':'));
	
	$dbuser = substr($dsn, strrpos($dsn, '/')+1);
	
	$mysqli = new mysqli($dbhost,$dbuser,$dbpasswd,$dbname);
	if($mysqli->connect_error){
		___putDebugLog("ERR: mysqli->connect_error発生. errorno[". $mysqli->connect_errno ."] errmsg[". mysqli_connect_error() ."]\n");
		return false;
	}
	
	if(!$mysqli->set_charset("utf8")){
		___putDebugLog("ERR: mysqli->set_charset(utf8)error発生. error[". $mysqli->error. "]\n");
		$mysqli->close();
		return false;
	}
	
	return $mysqli;
}
//CL_FNC
//認証データ取得
//
function getAuthParams(){
	$authparams = array('member_code' => 'FFFFFFFFFF', 'member_hashedpwd' => '');
	$mysqli = false;
	if(($mysqli = connectDB())===false){
		return $authparams;
	}
	$query = "SELECT  ".
			"(SELECT conf_value FROM ".DATABASE_PREFIX."config WHERE conf_name = 'accessibility_rubi_member_code' LIMIT 1) member_code, ".
			"(SELECT conf_value FROM ".DATABASE_PREFIX."config WHERE conf_name = 'accessibility_rubi_member_hashedpwd' LIMIT 1) member_hashedpwd";
	$mysqli_result = $mysqli->query($query);
	if($mysqli_result===FALSE){
		___putDebugLog("ERR: mysqli->query(".$query.")error発生. error[". $mysqli->error. "]\n");
		$mysqli->close();
		$mysqli = false;
		return authparams;
	}
	if(($row = $mysqli_result->fetch_assoc()) !== NULL){
		if(isset($row['member_code'])) {
			$authparams['member_code'] = $row['member_code'];
		}
		if(isset($row['member_hashedpwd'])) {
			$authparams['member_hashedpwd'] = $row['member_hashedpwd'];
		}
	}
	$mysqli_result->free(); //テーブルメモリ開放
	$mysqli->close();
	$mysqli = false;
	return $authparams;
}

//CL_FNC
//ルビ設定テーブルからのデータ取得
//
function getRubiSetTbl(&$mysqli){
	$query = "SELECT search_str, replace_str, page_ids, permalinks, short_urls, enable_flg FROM ".DATABASE_PREFIX."accessibility_rubi_set ORDER BY rubi_set_id ASC";
	$mysqli_result = $mysqli->query($query);
	if($mysqli_result===FALSE){
		___putDebugLog("ERR: mysqli->query(".$query.")error発生. error[". $mysqli->error. "]\n");
		$mysqli->close();
		$mysqli = false;
		return false;
	}
	$a = array();
	while(($row = $mysqli_result->fetch_assoc()) !== NULL){
		if(isset($row['search_str'])) {
			$row['search_str'] = base64_decode($row['search_str']);
		}
		if(isset($row['replace_str'])){
			$row['replace_str'] = base64_decode($row['replace_str']);
		}
		$a[] = $row;
	}
	$mysqli_result->free(); //テーブルメモリ開放
	$mysqli->close();
	$mysqli = false;

	return $a;
}
//
//キャッシュファイル名(sha1値)が一致するものをみつけ、記録しているルビ変換結果を返す。
//
function searchRubiCacheFile($dir, $sha1){
	$ret = false;
    clearstatcache(); //statcacheのクリアはここでいいはず

    if(($handle = @opendir($dir))!==false){
        while ($file = readdir($handle)) {
            if ($file === '.'){
                //自分なのでスルーする
                continue;
            } else if ($file === '..'){
                //親なのでスルーする
                continue;
            } else {
                //syslinkかdirかfile
                $path = $dir . '/' . $file;

                if(is_link($path) || is_dir($path)) {
                    //シンボリックリンクかディレクトリなのでスルーする
                	continue;
                }
                else if (is_file($path)) {
                    //実ファイル
                    if (is_readable($path)) {
						if($file === $sha1){
							//sha1値がファイル名だった！
							$ret = file_get_contents($path);
							break;
						}
                    } else {
                    	//read権限のないファイルは対象からはずす。ex. .xxxx.....swpなど
                		continue;
                    }
                } else {
                    //こんなの知らない。。。
                	continue;
                }
            }
        }
        closedir($handle);
	} else {
   		//opendir($dir) error.
	}

	return $ret;
}
//保存期間をすぎた古いキャッシュファイルを削除する(GCする)。
//キャッシュ保存日を拡張追加した版.
//
function deleteOldRubiCacheFileEx($dir,$days){
	if($days <= 0){
		return 0;	//キャッシュ日数が0の場合、なにもせず、リターンする。
	}

	$now = time();

	$saveterm = (3600 * 24 * $days);    //キャッシュの保存期間。3600秒(=１時間) x 24時間 = 1日. 1日 x キャッシュ日数(可変)
												//
    clearstatcache(); //statcacheのクリアはここでいいはず
	$oldpaths = array();
    if(($handle = @opendir($dir))!==false){
        while ($file = readdir($handle)) {
            if ($file === '.' || $file === '..'){
                //自分か親なのでスルーする
                continue;
            } else {
                //syslinkかdirかfile
                $path = $dir . '/' . $file;

                if(is_link($path) || is_dir($path)) {
                    //シンボリックリンクかディレクトリなのでスルーする
                	continue;
                }
                else if (is_file($path)) {
                    //実ファイル
                    if (is_writable($path)) {
						$stats = stat($path);
						if($now > ($stats['atime'] + $saveterm)){
							$oldpaths[] = $path;
						}
                    } else {
                    	//write権限のないファイルは対象からはずす。ex. .xxxx.....swpなど
                		continue;
                    }
                } else {
                    //こんなの知らない。。。
                	continue;
                }
            }
        }
        closedir($handle);
	} else {
        //opendirに失敗
	}

	//ここでoldpathsの各ファイルをrmする。
	foreach($oldpaths as $oldpath){
		unlink($oldpath);
	}

	return count($oldpaths);
}
function getWebApiServerPlace(){
	$server = '';
	$mysqli = false;
	if(($mysqli = connectDB())===false){
		return '';
	}
	$query = "SELECT conf_value FROM ".DATABASE_PREFIX."config WHERE conf_name = 'accessibility_rubi_api_server' LIMIT 1";
	$mysqli_result = $mysqli->query($query);
	if($mysqli_result===FALSE){
		___putDebugLog("ERR: mysqli->query(".$query.")error発生. error[". $mysqli->error. "]\n");
		$mysqli->close();
		$mysqli = false;
		return '';
	}
	if(($row = $mysqli_result->fetch_assoc()) !== NULL){
		if(isset($row['conf_value'])) {
			$server = $row['conf_value'];
		}
	}
	$mysqli_result->free(); //テーブルメモリ開放
	$mysqli->close();
	$mysqli = false;
	return $server;
}
function getCacheAllowFlagAndDays(&$rubi_cache_allow_flag,&$rubi_caching_day){
	$days = 0;
	$mysqli = false;
	if(($mysqli = connectDB())===false){
		return ;
	}
	$query = "SELECT  ".
			"(SELECT conf_value FROM ".DATABASE_PREFIX."config WHERE conf_name = 'accessibility_rubi_cache_allow_flag' LIMIT 1) rubi_cache_allow_flag, ".
			"(SELECT conf_value FROM ".DATABASE_PREFIX."config WHERE conf_name = 'accessibility_rubi_caching_day' LIMIT 1) rubi_caching_day";
	$mysqli_result = $mysqli->query($query);
	if($mysqli_result===FALSE){
		___putDebugLog("ERR: mysqli->query(".$query.")error発生. error[". $mysqli->error. "]\n");
		$mysqli->close();
		$mysqli = false;
		return ;
	}
	if(($row = $mysqli_result->fetch_assoc()) !== NULL){
		$rubi_cache_allow_flag = (isset($row['rubi_cache_allow_flag']) && $row['rubi_cache_allow_flag']==1) ? 1 : 0;
		$rubi_caching_day = (isset($row['rubi_caching_day']) && (0 < intval($row['rubi_caching_day'])) && (intval($row['rubi_caching_day']) < 100)) ? intval($row['rubi_caching_day']) : 0;
	}
	$mysqli_result->free(); //テーブルメモリ開放
	$mysqli->close();
	$mysqli = false;
	return;
}
//
function ___putDebugLog($str)
{
	error_log($str, 3, dirname(dirname(__FILE__))."/webapp/logs/"."rubi_error.log");
}
